local PANEL = {};

// link to class
function PANEL:LinkToClass( cls )
	self.LinkedClass = cls;
	
end

// button.
function PANEL:Init( )
	// linked to
	self.LinkedClass = nil;
	
	// create a label
	self.Label = vgui.Create( "label", self );
	
end

// set text
function PANEL:SetText( text )
	self.Label:SetText( text );

end


// perform layout
function PANEL:PerformLayout( )
	// position label
	self.Label:SizeToContents();
	self.Label:SetPos( 8, 8 );

end

//// scheme
function PANEL:ApplySchemeSettings( )
	// set font/color.
	self.Label:SetFont( AppFramework:Theme().fonts['title'] );
	self.Label:SetFGColor( AppFramework:Theme().colors['text'] );
	
end



// draw
function PANEL:Paint( )
	// fetch olors
	local color = AppFramework:Theme().colors['window_face'];
	local bgcolor = AppFramework:Theme().colors['border_dark'];
	
	// width/height
	local width, height = self:GetSize();
	
	// round rect
	draw.RoundedBox(
		8,
		0, 0,
		width, height,
		bgcolor
	);
	
	// square border.
	surface.SetDrawColor(
		bgcolor.r,
		bgcolor.g,
		bgcolor.b,
		bgcolor.a
	);
	surface.DrawRect(
		0, height - 9,
		width, 9
	);
	
	
	// round rect
	draw.RoundedBox(
		8,
		1, 1,
		width - 2, width - 2,
		color
	);
	
	// square border.
	surface.SetDrawColor(
		color.r,
		color.g,
		color.b,
		color.a
	);
	surface.DrawRect(
		1, height - 9,
		width - 2, 8
	);
	
	//
	return true;
	
end

// register
vgui.Register( "ctl_header", PANEL, "Panel" );




// create app framework control.
CtlHeader_class 	= Control_class:create( nil, false, "ctl_header" );

// set title
function CtlHeader_class:SetTitle( text )
	self:GetHandle():SetText( text );

end

